CREATE OR REPLACE FUNCTION TSystem.views__ReportingLdsdok__recreate() RETURNS VOID AS $$
BEGIN
    
    DROP VIEW IF EXISTS treporting.ldsdok_beleg_positionen CASCADE;
    CREATE OR REPLACE VIEW treporting.ldsdok_beleg_positionen AS
     SELECT
      'ldsdok'::VARCHAR(30)							                                      AS position_tablename,
      ldsdok.dbrid                                                            AS position_dbrid,
      ld_id					        				                                          AS position_id,
      ld_id									                                                  AS position_abzu_join_id,
      ld_code 								                                                AS position_status,
      CASE WHEN ld_a2_id IS NULL THEN ld_auftg ELSE FertArt.fertauftg    END  AS position_identnummer, --bestellung normal: bestellnummer; auswärtsbearbeitung: fertigungsauftragsnr
                                    
      CASE WHEN ld_a2_id IS NULL THEN ld_pos   ELSE FertArt.fertauftgpos END  AS position_identpos,
                                                         
      ld_datum								                                                AS datum_erfasst,								  								
      NULL::CHAR(1)								                                            AS referenz_identdatum,
      ld_pos::CHAR(5)							                                            AS position_coalesce_handwerker_posnr,
      CASE WHEN ld_a2_id IS NULL THEN NULL::VARCHAR(75) ELSE FertArt.a2_ab_ix||' / '|| FertArt.a2_n::VARCHAR(75) END
                                                                              AS position_identnummer1,
      NULL::INTEGER								                                            AS position_identpos1,  --auswärtsbestellung: ABK-Index
      NULL::DATE								                                              AS referenz_identdatum1,
        
      ld_dokunr								                                                AS position_dokument_id,
      ld_rhl_nr IS NOT NULL							                                      AS position_israhmenabruf,
      ld_rhl_nr								                                                AS position_rahmen_nr_referenz,
      (SELECT count(1) FROM ldsdok lr WHERE lr.ld_rhl_nr=ldsdok.ld_rhl_nr AND lr.ld_id<ldsdok.ld_id)
                                                                              AS position_rahmen_abrufnr,
                                                                              
      ld_ekref								                                                AS referenz,
      NULL::INTEGER								                                            AS referenz_pos,
      NULL::DATE								                                              AS referenz_vondatum,
      NULL::NUMERIC								                                            AS referenz_menge,		--Lieferschein: Menge Bestellt (Verkauf an Kunde)
      NULL::NUMERIC								                                            AS referenz_menge_erledigt,	--Lieferschein: Menge bereits geliefert 
                                                                              
      ld_lkontaktkrzl							                                            AS adresse_ansprechpartner_adressant_kurzzeichen,
      ld_lkontakt								                                              AS adresse_ansprechpartner_adressant,  
                                                                              
      ld_kontakt								                                              AS adresse_ansprechpartner_intern_ident,
      nameAufloesen(ld_kontakt)						                                    AS adresse_ansprechpartner_intern_name,
                                                                              
      ld_kn 								                                                  AS adresse_adressant,
      ld_krzl 								                                                AS adresse_lieferadresse,
      ld_krzf 								                                                AS adresse_rechnungsadresse,
     
      CASE WHEN ld_a2_id IS NULL THEN ld_aknr     ELSE FertArt.fertaknr  END  AS artikelnummer,			-- Bei Auswärtsvergabe, die eigene Fertigungsartikelnummer, nicht das arbeitspaket
      CASE WHEN ld_a2_id IS NULL THEN ld_aknr_idx ELSE FertArt.fertakidx END  AS artikelnummer_index,   -- Bei Auswärtsvergabe, Artikelindex Fert.Artikel oder Prod.Auftrag
      ld_bem								                                  AS artikelnummer_adressant,
      
      CASE WHEN ld_a2_id IS NULL THEN COALESCE(ld_bem, ld_aknr) ELSE FertArt.fertaknr END               -- Artikelnummer Lieferant oder eigene Artikel-Nr. (Fert.Artikel bei Auswärtsvergabe)
                                                                              AS artikelnummer_coalesce_adressant_intern,  									                  
      CASE WHEN ld_a2_id IS NULL 
        THEN COALESCE(ld_akbz, lang_artbez(ld_aknr, ReportLang_current()), ak_bez)
        ELSE COALESCE(lang_artbez(FertArt.fertaknr, ReportLang_current()), FertArt.fertakbez) 
      END    							                                      AS artikelbezeichnung, --prodat_languages.supplierlang(ld_kn)
      
      NULL::CHAR(1)								                              AS artikelbezeichnung_coalesce_adressant_intern,
      CASE WHEN ld_a2_id IS NULL THEN ak_znr ELSE FertArt.fertakznr END       AS artikel_zeichnungsnummer,
                                                          
      CASE WHEN ld_a2_id IS NULL 
        THEN COALESCE(lang_artdim(ld_aknr, ReportLang_current()), ak_dim)
        ELSE COALESCE(lang_artdim(FertArt.fertaknr, ReportLang_current()), FertArt.fertakdim) 
      END    							                                      AS artikel_dimension,
                                                          
      CASE WHEN ld_a2_id IS NULL 
        THEN COALESCE(lang_artmat(ld_aknr, ReportLang_current()), ak_mat)
        ELSE COALESCE(lang_artmat(FertArt.fertaknr, ReportLang_current()), FertArt.fertakmat) 
      END       						                                      AS artikel_materialnummer,  									                  
      ak_din                                                                  AS artikel_materialnorm,									
      CASE WHEN ld_a2_id IS NULL 
        THEN ld_stk_uf1*ak_gewicht 
        ELSE (SELECT ld_stk_uf1*o2_gewicht FROM op2 JOIN ab2 ON o2_id=a2_o2_id WHERE a2_id=ld_a2_id) 
      END								                                      AS artikel_pos_gewicht,
                                                          
      NULL::INTEGER								                              AS artikel_kost_rust,
      NULL::INTEGER								                              AS artikel_kost_fert,
      NULL::INTEGER								                              AS artikel_kost_mat,
      NULL::INTEGER								                              AS artikel_kost_aw,
      ak_warencode								                              AS artikel_warencode,
      
      CASE WHEN ld_a2_id IS NULL THEN ak_fertigung ELSE True END              AS artikel_fert, -- bei Auswärtsbestellung nehme an, es ist Fertigungsartikel, Bedingung für Option UseZeichnungAsArtNo
                                                          
      (SELECT lang_land( ak_l_iso, ReportLang_current() ))			          AS artikel_ursprung,    
      
      ld_done								                                  AS done,
      ld_storno								                                  AS storno,
      False									                                  AS optional,
                                                                              
      ld_kurs								                                  AS kurs_waer,
      ld_preis								                                  AS preis_me_netto,  -- Vorher ld_ep
      ld_preiseinheit                                                         AS preiseinheit,    -- #6447, #6772
      ld_ep_uf1								                                  AS preis_me_netto_uf1,
      ld_ep_basis_w 							                              AS preis_me_netto_basis_w,
      ld_ep_uf1_basis_w							                              AS preis_me_netto_basis_w_uf1, 
      COALESCE(ld_ekp_mce, ld_mce)                                            AS preis_mengeneinheit_artmgc_id, -- 7678
      lang_artmgc_id_iso(COALESCE(ld_ekp_mce, ld_mce), ReportLang_current())  AS preis_mengeneinheit_bez_iso, -- 7678
      ld_netto								                                  AS preis_inkl_rabatt_abzu,
      ld_brutto								                                  AS preis_inkl_rabatt_abzu_steuer,
      ld_preis*(1-ld_arab/100) /*IFTHEN(ld_canrabatt, (1-ld_arab/100), 1))*/  AS preis_me_inkl_posrabatt_ohne_abzu,
      ld_ep_netto								                              AS preis_me_inkl_rabatt_ohne_abzu,
      ldsdok_pos_wert_calc(ld_id, false, false) 		                      AS preis_positionswert_nur_hauptpos_werthaltig,
      twawi.ldsdok__abzu__netto__by__ld_id(ld_id)                             AS preis_pos_abzusum,
    
      true									                                  AS poshatvkp,
      ld_steuproz								                              AS steuproz,
      ld_stk								                                  AS menge,
      ((tartikel.me__menge_uf1__in__menge(COALESCE(ld_ekp_mce, ld_mce), ld_stk_uf1))/Do1If0(ld_stk))::NUMERIC(12,4)  AS menge_1in_preiseinheit,  -- 7678 Umrechnungsfaktor: 1 Einheit der Menge entspricht 1 Einheit der Menge des Preises
      ld_eklos                                                                AS menge_rahmen_abrlos,
      ld_stk_uf1								                              AS menge_uf1,
      ld_stkl								                                  AS menge_geliefert_uf1,
      ld_stkf								                                  AS menge_verrechnet,
      --ag_stk_offen							              AS menge_offen_mengeneinheit,
      ld_stkl-ld_stk_uf1							                          AS menge_offen_uf1,
      ld_arab								                                  AS rabatt,
      NULL::FLOAT                                                             AS rabatt_hint,
      ltd_gesrab                                                              AS rabatt_ges,
      ld_mce								                                  AS mengeneinheit_artmgc_id,
      lang_artmgc_id_iso(ld_mce, ReportLang_current()) 	                      AS mengeneinheit_bez_iso,
      
      COALESCE(IFTHEN(Trim(ld_txt_rtf)='', NULL::TEXT, ld_txt_rtf), ld_txt)::TEXT AS postxt_rtf,
      
      ld_an_nr								                                  AS an_nr,
      (SELECT an_bez FROM anl WHERE an_nr=ld_an_nr)                           AS an_bez,  
      ld_term								                                  AS datum_geplant,
      ld_terml								                                  AS datum_bestaetigt,
      COALESCE(ld_terml, ld_term)						                      AS datum_coalesce_bestaetigt_geplant,
      NULL::CHAR(1)								                              AS datum_text,
      ld_termweek								                              AS datum_woche_geplant,
      ld_termweekl								                              AS datum_woche_bestaetigt,
      COALESCE(ld_termweekl, ld_termweek)				                      AS datum_woche,
      NULL::DATE								                              AS datum_auslieferung
     FROM
       ldsdok JOIN art ON ak_nr=ld_aknr
         LEFT JOIN ldsdokdokutxt ON ltd_dokunr=ld_dokunr
         LEFT JOIN LATERAL ( SELECT * FROM tabk.abk__fertdata__by__a2_id(ld_a2_id) ) AS FertArt ON ld_a2_id IS NOT NULL  AND fertart.a2_id = ld_a2_id
     ORDER BY
      ld_code, ld_auftg, ld_pos;
      
    
    DROP VIEW IF EXISTS treporting.ldsdok_beleg_positionenmahn;
    CREATE OR REPLACE VIEW treporting.ldsdok_beleg_positionenmahn AS
     SELECT
      tartikel.me__menge_uf1__in__menge(ld_mce, ld_stk_uf1)					AS referenz_menge,				--Menge Bestellt (Verkauf an Kunde)
      tartikel.me__menge_uf1__in__menge(ld_mce, IFTHEN(ld_done, ld_stk_uf1, ld_stkl))		AS referenz_menge_erledigt,			--Menge bereits geliefert ;; wenn erledigt, dann wird Geliefert=Bestellt gesetzt, um Restmenge auszublenden
      position_id AS id
     FROM
      treporting.ldsdok_beleg_positionen JOIN ldsdok ON ld_id=treporting.ldsdok_beleg_positionen.position_id
     WHERE NOT
      done
    ;
      
      
    DROP VIEW IF EXISTS treporting.ldsdok_beleg_kopfdaten CASCADE;
    CREATE OR REPLACE VIEW treporting.ldsdok_beleg_kopfdaten AS
     SELECT
       ltd_dokunr::VARCHAR							                AS dokument_id,		--wegen FR auf Varchar casten, dort wird dokument_id mit dokument_nummer verglichen
       ltd_dokunr								                        AS dokument_join_id,
       ltd_dokunr	 	 						                        AS dokument_dms_id, 

       IFTHEN((SELECT count(1) FROM (SELECT ld_auftg FROM ldsdok WHERE ld_dokunr=ltd_dokunr AND ld_a2_id IS NULL /* AND ld_a2_id IS NULL siehe unten ~ zurückgesetzt, konzept nicht fertig*/ GROUP BY ld_auftg)AS a)=1    --nur ein Auftrag im Dokument, dann ist unsere Dokumentnummer=Auftragsnummer
              ,(SELECT ld_auftg FROM ldsdok WHERE ld_dokunr=ltd_dokunr LIMIT 1)
              ,ltd_dokunr::VARCHAR(50))
                                                        AS dokument_nummer,

       NULL::NUMERIC 					                          AS dokument_anzahlprozent,
       ld_code	 							                          AS dokument_status,
       
       (SELECT count(1) FROM (SELECT ld_auftg FROM ldsdok WHERE ld_dokunr=ltd_dokunr GROUP BY ld_auftg)AS a)>1 AS dokument_multidok, --/*AND ld_a2_id IS NULL*//*Bei Auswärts immer Multidok, damit die Abrufe auch die richtige Positionsnummer enthalten und nicht 3 mal die Position 1 drauf steht*/
       true									                            AS definitiv,       															
                                        
       IFTHEN(ldsdok_is_awbest(ltd_dokunr),'awd','ldsdok_bestdok')::VARCHAR(20)
                                                        AS doktype_force,
                                        
       ltd_datum                            						AS dokument_erstelldatum,
       
       IFTHEN(ld_code='R', 'trans.kopf.ihrrahmenangebot', 'trans.kopf.ihrangebot')::VARCHAR(75)	AS dokument_reftitkunde,
       IFTHEN(ld_code='R', 'trans.kopf.unserrahmenbest', IFTHEN(ldsdok_is_awbest(ltd_dokunr), 'trans.kopf.fertnr', 'trans.kopf.unserebest'))::VARCHAR(75)
                                                        AS dokument_reftiteigen,

       IFTHEN(ldsdok_is_awbest(ltd_dokunr), 'trans.kopf.abkindex', NULL::CHAR(1))::VARCHAR(75)
                                                        AS dokument_reftiteigen1,
       /*
       COALESCE(ltd_titel,
            IFTHEN((SELECT count(1) FROM (SELECT ld_auftg FROM ldsdok WHERE ld_dokunr=ltd_dokunr GROUP BY ld_auftg)AS a)=1    --nur ein Auftrag im Dokument, dann ist unsere Dokumentnummer=Auftragsnummer
              ,IFTHEN(ld_code='R', 'trans.kopf.rahmenbest', IFTHEN(ldsdok_is_awbest(ltd_dokunr), 'trans.kopf.lfsawauftrag', 'trans.kopf.bestellung'))
              ,IFTHEN(ld_code='R', 'trans.kopf.rahmenbestdok', IFTHEN(ldsdok_is_awbest(ltd_dokunr), 'trans.kopf.lfsawauftrag', 'trans.kopf.bestdok'))))::VARCHAR(75)
                                        AS dokument_titel, */
                                        
       CASE WHEN ltd_titel IS NOT NULL THEN ltd_titel
         ELSE 
           CASE WHEN (SELECT count(1) FROM (SELECT ld_auftg FROM ldsdok WHERE ld_dokunr=ltd_dokunr GROUP BY ld_auftg)AS a)=1 THEN    --nur ein Auftrag im Dokument, dann ist unsere Dokumentnummer=Auftragsnummer   
             CASE WHEN (ld_code='R') THEN 'trans.kopf.rahmenbest'
               ELSE IFTHEN(ldsdok_is_awbest(ltd_dokunr), 'trans.kopf.lfsawauftrag', 'trans.kopf.bestellung')
             END
           ELSE
             CASE WHEN (ld_code='R') THEN 'trans.kopf.rahmenbestdok'
               ELSE IFTHEN(ldsdok_is_awbest(ltd_dokunr), 'trans.kopf.lfsawauftrag', 'trans.kopf.bestdok')
             END          
         END 
       END                                              AS dokument_titel,      
        
       CASE WHEN (SELECT count(1) FROM (SELECT ld_auftg FROM ldsdok WHERE ld_dokunr=ltd_dokunr GROUP BY ld_auftg)AS a)=1 THEN    --nur ein Auftrag im Dokument, dann ist unsere Dokumentnummer=Auftragsnummer   
           CASE WHEN (ld_code='R') THEN 'trans.kopf.rahmenbest'
             ELSE IFTHEN(ldsdok_is_awbest(ltd_dokunr), 'trans.kopf.lfsawauftrag', 'trans.kopf.bestellung')
           END
       ELSE
           CASE WHEN (ld_code='R') THEN 'trans.kopf.rahmenbestdok'
             ELSE IFTHEN(ldsdok_is_awbest(ltd_dokunr), 'trans.kopf.lfsawauftrag', 'trans.kopf.bestdok')
           END          
       END::varchar(100)                                                AS dokument_titel_doktype,
       COALESCE(ltd_txt_rtf, ltd_txt)					AS dokument_kopftext,
       COALESCE(ltd_txt1_rtf, ltd_txt1)					AS dokument_fusstext,
       --Q-Hint. Wenn nix gefunden wird, wird durch das COALESCE automatisch der Standard-QHint geladen!
       (belarzu__zu_tit__gettxt('DOKEINKAUF_QHINT'||COALESCE('-'||(SELECT ld_nident FROM ldsdok WHERE ld_dokunr=ltd_dokunr AND ld_nident IS NOT NULL ORDER BY ld_pos LIMIT 1), ''), ReportLang_current() ))
                                                        AS dokument_qhint,
       
       NULL::TEXT								        AS dokument_exporttxt,
       NULL::TEXT								        AS dokument_exportursprungtxt,
       belarzu__zu_tit__gettxt('DOKU_EMAILTXT', ReportLang_current(), false)
                                                        AS dokument_emailtxt,   
       
       ((SELECT count(1) FROM (SELECT DISTINCT ld_auftg, COALESCE(ld_ekref,''), COALESCE(ld_an_nr,'') FROM ldsdok WHERE ld_dokunr=ltd_dokunr) AS a)) AS dokument_positiongroupcount, --eine gleiche referenz über alles?
       
       ltd_apkrzl								        AS dokument_adresse_ansprechpartner_adressant_ident,
       ltd_ap								            AS dokument_adresse_ansprechpartner_adressant,
       ap_anr								            AS dokument_adresse_ansprechpartner_adressant_anr,
       ap_sex_man::VARCHAR(1)                           AS dokument_adresse_ansprechpartner_adressant_man,
       ap_name								            AS dokument_adresse_ansprechpartner_adressant_nachname,
       ap_vorn                            AS dokument_adresse_ansprechpartner_adressant_vorname,
       ap_sysfun                          AS dokument_adresse_ansprechpartner_adressant_sysfun,
       ap_titel								            AS dokument_adresse_ansprechpartner_adressant_titel,
       
       ld_kn                                            AS dokument_adresse_adressant,
       adk_ad_krz                                       AS dokument_adresse_ident, --zB dbrid für Parameter 
       
       ad_ustidnr								        AS ustidnr,
       
       sum_ldsdok_dokunr(ltd_dokunr) 					AS dokument_summe_netto,
       sum_ldsdok_dokunr(ltd_dokunr, true) 				AS dokument_summe_brutto,
    
       NULL::FLOAT								        AS dokument_fixwert,
       ltd_gesrab								        AS dokument_gesamtrabatt,
       (SELECT SUM(ld_preis*ld_stk*(1-ld_arab/100)-ld_ep_netto*ld_stk) FROM ldsdok WHERE ld_dokunr=ltd_dokunr AND ltd_gesrab>0 /*AND ld_canrabatt*/)
                                                        AS dokument_gesamtrabatt_wert,
       
       ltd_abbisdat								        AS dokument_bindefrist,
       
       ltd_apint								        AS dokument_adresse_ap_intern_ident,
       nameAufloesen(ltd_apint)						    AS dokument_adresse_ap_intern_name,
       ltd_apint2								        AS dokument_adresse_ap_intern_ident2,
       nameAufloesen(ltd_apint2)						AS dokument_adresse_ap_intern_name2,
       
       COALESCE(ap_mail, ad_email1) 					AS adresse_adressant_email,
       
       (nullif(a2_knr,-1))::VARCHAR(50)				    AS dokument_adresse_knr_debi_or_kredi,  --PRODAT Lieferantennummer
       a2_eknr::VARCHAR(50)							    AS dokument_adresse_adressant_knr_debi_or_kredi,  --Eigene Kundennummer beim Lieferant
       COALESCE(ld_waer, a2_waco, TSystem.Settings__Get('BASIS_W'))
                                                        AS zahlung_waco,
                                                        
       a2_spco								            AS sprache_debi_or_kredi, 
       a2_tolfrueh								        AS lieftolfrueh_debi_or_kredi,
       a2_tolspaet								        AS lieftolspaet_debi_or_kredi,
       NULL::BOOLEAN							        AS euexport,
       NULL::BOOLEAN							        AS intexport,
       NULL::VARCHAR							        AS zazexport,	--ZAZ Nummer nur zeigen wenn Export
       NULL::VARCHAR                                    AS eori_vertragspartner,    --EORI des Kunden
       
       ltd_zak								            AS zahlung_tage_zahlungbis,
       ltd_skv								            AS zahlung_tage_skontoverfall,
       ltd_sks								            AS zahlung_skontosatz_prozent,
       
       lang_za(a2_zahlart,ReportLang_current())         AS zahlung_zahlart_name_debikredidat,
       ltd_zakbem 								        AS zahlung_zahlkondition_bemerkung,
       
       kto_bknr,
       kto_blz,
       kto_bank,
       kto_bic,
       kto_iban,
       kto_pckonto,
       kto_bb,
       
       (SELECT s_bb FROM adkspco WHERE a2_spco = s_spco)			
                                                        AS s_bb, --Hintergrund-Einstellung aus Sprache NEU   
    
       NULL::INTEGER							        AS versand_versandart_ident,
       COALESCE(lang_versart(v_id, ReportLang_current() ), ltd_vers)	
                                                        AS versand_versandart, -- neu #7137, war COALESCE(v_descr,ltd_vers)
       ltd_versandort                                   AS versand_versandort,-- Ort des Gefahrenübergangs
       COALESCE(ltd_versandbem_rtf, ltd_versandbem)		AS versand_bem,  
       (SELECT (TAdk.DokVersandTyp(ad_dokversand)).ad_DokVersandBez FROM adk WHERE adk.ad_krz=adk_ad_krz) 
                                                        AS dokument_versand, -- Dokumenten-Versandbezeichnung Adressstammdaten
       
       (SELECT MAX(ld_preiseinheit) FROM ldsdok WHERE ld_dokunr=ltd_dokunr)  
                                                        AS preiseinheit_max,   
       1                                                AS hwpos_max, --Strukturposition
       1                                                AS bdapos_max, --Länge Bestellpostion Kunde #12607
       
       (SELECT MAX(numeric_larger(LENGTH((ld_stk-trunc(ld_stk))::FLOAT::VARCHAR)-2,0)) FROM ldsdok WHERE ld_dokunr=ltd_dokunr)  --Float cast wirft nachfolgende 0en weg  http://postgresql.1045698.n5.nabble.com/strip-zeros-from-fractional-part-td1849963.html
                                                        AS dokument_menge_numdigits,
       (SELECT MAX(numeric_larger(LENGTH((ld_preis-trunc(ld_preis))::FLOAT::VARCHAR)-2,0)) FROM ldsdok WHERE ld_dokunr=ltd_dokunr)
                                                        AS dokument_vkp_numdigits,
       (SELECT MAX(numeric_larger(LENGTH(((ld_preis*(1-ld_arab/100))-trunc((ld_preis*(1-ld_arab/100))))::FLOAT::VARCHAR)-2,2)) FROM ldsdok WHERE ld_dokunr=ltd_dokunr)
                                                        AS dokument_arab_numdigits --Analog Verkauf und Rechnung umgesetzt   									     
     FROM
       ldsdokdokutxt 		JOIN ldsdok ON ld_id=(SELECT ld_id FROM ldsdok WHERE ld_dokunr=ltd_dokunr ORDER BY ld_pos LIMIT 1) --treporting.auftg_beleg_positionen ON atd_dokunr=belegdokumentnummer
                    LEFT JOIN adressen_view ON ad_krz=ld_kn
                    LEFT JOIN adk2 ON a2_krz=adk_ad_krz --Kreditorendaten zur Adresse
                    LEFT JOIN ktovz ON /*kto_name=a2_ktv_name OR */(/*a2_ktv_name IS NULL AND */kto_std)
                    LEFT JOIN adkap ON adk_ad_krz=ap_ad_krz AND ap_krzl=ltd_apkrzl AND ap_krzl IS NOT NULL 
                    LEFT JOIN versart ON v_art ILIKE ltd_vers; --LIKE-JOIN http://redmine.prodat-sql.de/issues/4981#note-6               		  	
    
    
    DROP VIEW IF EXISTS treporting.ldsdok_belegmahn_kopfdaten;
    CREATE OR REPLACE VIEW treporting.ldsdok_belegmahn_kopfdaten AS
     SELECT
      COALESCE(ltd_titel, 'trans.kopf.termmahnung'::VARCHAR(75))		AS dokument_titel,
      'trans.kopf.termmahnung'::VARCHAR(75)		                        AS dokument_titel_doktype,
      'ldsdok_bestdok_mahn'::VARCHAR(20)					            AS doktype_force,
      ltd_mahndat								                        AS dokument_erstelldatum,
      ltd_mahnstufe								                        AS mahnstufe,
      COALESCE(ltd_mahntxt_rtf, ltd_mahntxt)				            AS dokument_kopftext,
      COALESCE(ltd_mahntxt1_rtf, ltd_mahntxt1)			 	            AS dokument_fusstext,
      dokument_id                                                       AS id
     FROM
      treporting.ldsdok_beleg_kopfdaten JOIN ldsdokdokutxt ON dokument_join_id=ltd_dokunr;
     
     
      
    
    
    DROP VIEW IF EXISTS treporting.ldsdok_abzuschlaege_pos;
    CREATE OR REPLACE VIEW treporting.ldsdok_abzuschlaege_pos AS
     SELECT
      ldaz_ld_id								                        AS position_id,
      ldaz_abz_id                                                       AS abzuid,
      lang_abzu(ldaz_abz_id, ReportLang_current())				        AS bezeichnung,
      ldaz_type                                                         AS typ, --                  #7938 PHKO
      ldaz_pos                                                          AS pos, --                  #7938 PHKO
      ldaz_anz								                            AS anzahl,
      ldaz_betr								                            AS preis,
      ldaz_anz*ldaz_betr							                    AS preis_wert_netto,
      ldaz_proz								                            AS prozent,
      ldaz_steucode								                        AS steuercode,
      ldaz_steuproz								                        AS steuerprozent,
      ldaz_visible 								                        AS sichtbar,
      COALESCE(ldaz_zutxt_rtf, ldaz_zutxt)                        		AS bemerkung,--              #7938 PHKO COALESCE(ldaz_zutxt_rtf,ldaz_zutxt)
      ldaz_zutxt_int                    								AS bemerkung_intern,--       #7938 PHKO
      (SELECT MAX(numeric_larger(LENGTH(ABS(ldaz_anz-trunc(ldaz_anz))::FLOAT::VARCHAR)-2,0)) FROM ldsabzu WHERE ld_id = ldaz_ld_id)  --Float cast wirft nachfolgende 0en weg  http://postgresql.1045698.n5.nabble.com/strip-zeros-from-fractional-part-td1849963.html
                                                                        AS abzu_menge_numdigits,
      ((SELECT MAX(numeric_larger(LENGTH(ABS(ldaz_betr-trunc(ldaz_betr))::FLOAT::VARCHAR)-2,0)) FROM ldsabzu WHERE ld_id = ldaz_ld_id))
                                                                        AS abzu_preis_numdigits
     FROM
      ldsabzu
      JOIN ldsdok ON ld_id = ldaz_ld_id
      
     UNION
     
     SELECT
      aprt_ldid								                            ,--AS position_id,
      NULL                                                              ,-- AbzuId
      COALESCE(NullIf(TRIM(apr_doktxt), ''), aprt_bez)		            ,--AS bezeichnung,
      NULL::CHAR(1)                                                     ,--AS typ                  
      NULL::INTEGER                                                     ,--AS pos                  O
      1								    ,--AS anzahl,
      NULL  						            ,--AS preis,
      NULL						                     ,--AS preis_wert_netto,
      NULL							                                    ,--AS prozent,
      NULL							                                    ,--AS steuercode,
      NULL							                                    ,--AS steuerprozent,
      TRUE									                            ,--AS sichtbar,
      aprt_txt								                            ,--AS bemerkung,
      NULL                                                              ,--AS bemerkung_intern,        
      NULL                                                              ,--AS abzu_menge_numdigits,
      NULL                                                               --AS abzu_preis_numdigits
     FROM
      artPruefungTest LEFT JOIN artpruefung ON aprt_apr_id=apr_id
     WHERE
      apr_aufdok AND COALESCE(apr_abz_id,0) NOT IN (SELECT ldaz_abz_id FROM ldsabzu WHERE aprt_ldid=ldaz_ld_id)/*Ausschliessen von Datensätzen, die bereits durch Abzuschlag auf Dokument*/
    
    UNION
    -- #7949 PHKO 
     SELECT 
      ld_id                                ,--AS position_id,
      NULL                                 ,-- AbzuId
      treporting.NormZert_customer_descr(normzert, qsnorm, qsnorm_descr, pre_NormZertTyp),--AS bezeichnung,
      lang_text(/*Norm*/ 4119)::VARCHAR(15),--AS typ                  
      NULL::INTEGER                        ,--AS pos                  
      1                                    ,--AS anzahl,
      NULL                                   ,--AS preis,
      NULL                                    ,--AS preis_wert_netto,
      NULL                                 ,--AS prozent,
      NULL                                 ,--AS steuercode,
      NULL                                 ,--AS steuerprozent,
      TRUE                                 ,--AS sichtbar,
      a2ba_txt                              ,--AS bemerkung,
      NULL                                 ,--AS bemerkung_intern,       
      NULL                                 ,--AS abzu_menge_numdigits,
      NULL                                 --AS abzu_preis_numdigits
    FROM
      ldsdok
      JOIN ab2ba ON a2ba_a2_id = ld_a2_id
      JOIN normzert ON noz_id = a2ba_noz_id
      JOIN qsnorm ON qs_ident = noz_qs_ident 
      LEFT JOIN qsnorm_descr ON qsd_id = noz_descr
      LEFT JOIN pre_NormZertTyp ON pnzt_type = qs_pnzt_type
     WHERE false --MF: temporär deaktiviert Klärung #7949 
    ORDER BY pos,bezeichnung;
      
      
    DROP VIEW IF EXISTS treporting.ldsdok_abzuschlaege_beleg;
    CREATE OR REPLACE VIEW treporting.ldsdok_abzuschlaege_beleg AS
      SELECT
       0									                           AS dokument_id,
       lang_abzu(ldaz_abz_id, prodat_languages.curr_lang())					           AS bezeichnung, -- TODO: prodat_languages.supplierlang(ld_kn)
       ldaz_type                                                       AS typ, --                  #7938 PHKO
       ldaz_pos                                                        AS pos, --                  #7938 PHKO
       ldaz_anz								                           AS anzahl,
       ldaz_betr								                       AS preis,
       ldaz_anz*ldaz_betr							                   AS preis_wert_netto,
       ldaz_proz								                       AS prozent,
       ldaz_steucode							                       AS steuercode,
       ldaz_steuproz							                       AS steuerprozent,
       TRUE									                           AS sichtbar,
       COALESCE(ldaz_zutxt_rtf,ldaz_zutxt)							   AS bemerkung,--              #7938 PHKO
       ldaz_zutxt_int                    							   AS bemerkung_intern--        #7938 PHKO
      FROM
       ldsabzu
       ORDER BY 4
      LIMIT 0;--momentan keine belegabzuschläge möglich
      
    DROP VIEW IF EXISTS treporting.ldsdok_steuerartenbetrag;
    CREATE OR REPLACE VIEW treporting.ldsdok_steuerartenbetrag AS
     SELECT
        dokument_id,
        steucode,
        steuproz,
        steubetrag,
        steubez
      FROM
      (SELECT
        ld_dokunr								AS dokument_id,
        ld_steucode								AS steucode,
        ld_steuproz								AS steuproz,
        SUM(ld_brutto-ld_netto-COALESCE((SELECT sum(ldaz_anz*ldaz_betr*COALESCE(ldaz_steuproz/100,1)) FROM ldsabzu WHERE ldaz_ld_id=ldsdok.ld_id AND NOT ldaz_steucode=ld_steucode),0)) AS steubetrag,
        lang_steu(ld_steucode, ReportLang_current())  			AS steubez
       FROM
        ldsdok
       WHERE not ld_storno
       GROUP BY
        ld_dokunr, ld_steucode, ld_steuproz, 5 
       UNION
       SELECT
        ld_dokunr								AS dokument_id,
        ldaz_steucode								AS steucode,
        ldaz_steuproz								AS steuproz,
        SUM(ldaz_anz*ldaz_betr*COALESCE(ldaz_steuproz/100,1))					AS steubetrag,
        lang_steu(ldaz_steucode, ReportLang_current())  			AS steubez
       FROM
        ldsabzu
       JOIN ldsdok ON ld_id=ldaz_ld_id AND NOT ldaz_steucode=ld_steucode
       WHERE NOT ld_storno
       GROUP BY
        ld_dokunr, ldaz_steucode, ldaz_steuproz, 5
      ) AS summe
     ; 
     
 
END $$ LANGUAGE plpgsql;

--SELECT TSystem.views__ReportingLdsdok__recreate();
